/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSWSDLRefs;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class VWPartnerLinkDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7456L;
    protected String m_Name = null;
    private String m_MyPortType = null;
    private String m_MyRole = null;
    private String m_PartnerEndPoint = null;
    private String m_PartnerPortType = null;
    private String m_PartnerRole = null;
    private String m_PartnerLinkRef = null;
    private String m_WSDLRef = null;
    private Vector m_ReceiveInstns = new Vector();
    private Vector m_ReplyInstns = new Vector();
    private VWWorkflowDefinition myWorkflow;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-24 08:28:21 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Quynh Dang;4D9941897;quynhdang@us.ibm.com (qdang) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/8 $";
    }

    protected VWPartnerLinkDefinition(VWWorkflowDefinition theWorkflow, String theName) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionInvalidWorkflow", "theWorkflow is invalid, (null).");
        }
        this.myWorkflow = theWorkflow;
        this.setName(theName);
    }

    public String getName() {
        return this.translateStr(this.m_Name);
    }

    public String getMyPortType() {
        return this.m_MyPortType;
    }

    public String getMyRole() {
        return this.m_MyRole;
    }

    public String getPartnerEndPoint() {
        return this.m_PartnerEndPoint;
    }

    public String getPartnerPortType() {
        return this.m_PartnerPortType;
    }

    public String getPartnerRole() {
        return this.m_PartnerRole;
    }

    public String getPartnerLinkRef() {
        return this.m_PartnerLinkRef;
    }

    public String getWSDLRef() {
        return this.m_WSDLRef;
    }

    public void setName(String theName) throws VWException {
        int i;
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionInvalidName", "Setting partner link name, theName is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_Name)) {
            return;
        }
        int nMaxLength = 113;
        if (theName.length() > nMaxLength) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionInvalidNameTooLong", "Setting partner link name, theName is invalid because it contains more than {0} characters.", nMaxLength);
        }
        for (i = 1; i < theName.length(); ++i) {
            char c = theName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new VWException("vw.api.VWPartnerLinkDefinitionInvalidNameBadCharacter", "Setting partner link name, theName is invalid because it contains an invalid character \"{0}\", the name can only contain letters, digits and underscore characters.", String.valueOf(c));
        }
        if (this.getWorkflowDefinition().isExistingPartnerLinkName(theName)) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionNameAlreadyExists", "Setting partner link name, theName is invalid, (a partner link named {0} already exists in this workflow definition).", theName);
        }
        this.m_Name = theName;
        if (this.m_ReceiveInstns != null) {
            for (i = 0; i < this.m_ReceiveInstns.size(); ++i) {
                ((VWReceiveInstruction)this.m_ReceiveInstns.elementAt(i)).setPartnerLinkName(theName);
            }
        }
        if (this.m_ReplyInstns != null) {
            for (i = 0; i < this.m_ReplyInstns.size(); ++i) {
                ((VWReplyInstruction)this.m_ReplyInstns.elementAt(i)).setPartnerLinkName(theName);
            }
        }
    }

    public void setMyPortType(String theMyPortType) throws VWException {
        this.m_MyPortType = theMyPortType;
    }

    public void setMyRole(String theMyRole) throws VWException {
        this.m_MyRole = theMyRole;
    }

    public void setPartnerEndPoint(String thePartnerEndPoint) throws VWException {
        this.m_PartnerEndPoint = thePartnerEndPoint;
    }

    public void setPartnerPortType(String thePartnerPortType) throws VWException {
        this.m_PartnerPortType = thePartnerPortType;
    }

    public void setPartnerRole(String thePartnerRole) throws VWException {
        this.m_PartnerRole = thePartnerRole;
    }

    public void setPartnerLinkRef(String thePartnerLinkRef) {
        this.m_PartnerLinkRef = thePartnerLinkRef;
    }

    public void setWSDLRef(String theWSDLRef) {
        this.m_WSDLRef = theWSDLRef;
    }

    protected VWWorkflowDefinition getWorkflowDefinition() {
        return this.myWorkflow;
    }

    protected void setWorkflow(VWWorkflowDefinition theWorkflow) {
        this.myWorkflow = theWorkflow;
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWWebServiceParameterDefinition B;
        int iA;
        VWWebServiceParameterDefinition[] paramB;
        Enumeration inner;
        Enumeration outer;
        VWValidationError theError2;
        VWString theMessage;
        if (this.myWorkflow == null) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionNullWorkflowRef", "No reference to containing workflow definition, runtime milestone definition, cannot validate.");
        }
        if (this.m_Name == null || this.m_Name.length() == 0) {
            theMessage = new VWString("vw.api.VWPartnerLinkNullName", "Partner link name is null or empty");
            theError2 = new VWValidationError(10, 1, null, null, theMessage.toString(), null);
            validationContext.addValidationError(theError2);
        }
        if (!(this.m_PartnerPortType != null && this.m_PartnerPortType.length() != 0 || this.m_MyPortType != null && this.m_MyPortType.length() != 0)) {
            theMessage = new VWString("vw.api.VWPartnerLinkBadPortTypeCombination", "Both MyPortType and PartnerPortType are null or empty, at least one of them must have a non-null value.");
            theError2 = new VWValidationError(10, 1, this.m_Name, null, theMessage.toString(), null);
            validationContext.addValidationError(theError2);
        }
        if (this.m_MyPortType != null && (this.m_ReceiveInstns == null || this.m_ReceiveInstns.size() == 0)) {
            theMessage = new VWString("vw.api.VWPartnerLinkMyPortTypeButNoReceivesInWorkflow", "MyPortType is not null, ( so this is a receive partner link ), but there are no receive instruction defined in this workflow that uses this partnerlink.");
            theError2 = new VWValidationError(10, 1, this.m_Name, null, theMessage.toString(), null);
            validationContext.addValidationError(theError2);
        }
        if (this.m_PartnerPortType != null && this.m_PartnerPortType.length() != 0 && (this.m_PartnerEndPoint == null || this.m_PartnerEndPoint.length() == 0)) {
            theMessage = new VWString("vw.api.VWPartnerLinkBadPartnerPortTypePartnerEndPointCombination", "PartnerPortType is {0}, but the PartnerEndPoint is null or empty.", this.m_PartnerPortType);
            theError2 = new VWValidationError(10, 1, this.m_Name, this.m_PartnerPortType, theMessage.toString(), null);
            validationContext.addValidationError(theError2);
        }
        if (this.m_PartnerEndPoint != null && this.m_PartnerEndPoint.length() != 0 && (this.m_PartnerPortType == null || this.m_PartnerPortType.length() == 0)) {
            theMessage = new VWString("vw.api.VWPartnerLinkBadPartnerPortTypePartnerEndPointCombination2", "PartnerEndPoint is {0}, but the PartnerPortType is null or empty.", this.m_PartnerEndPoint);
            theError2 = new VWValidationError(10, 1, this.m_Name, this.m_PartnerPortType, theMessage.toString(), null);
            validationContext.addValidationError(theError2);
        }
        if (!this.m_ReplyInstns.isEmpty()) {
            outer = this.m_ReplyInstns.elements();
            while (outer.hasMoreElements()) {
                VWReplyInstruction repA = (VWReplyInstruction)outer.nextElement();
                inner = this.m_ReplyInstns.elements();
                block10: while (inner.hasMoreElements()) {
                    VWReplyInstruction repB = (VWReplyInstruction)inner.nextElement();
                    if (repA == repB || repA.getOperationName() == null || repA.getOperationName().length() <= 0 || repB.getOperationName() == null || repB.getOperationName().length() <= 0 || !repA.getOperationName().equals(repB.getOperationName())) continue;
                    VWWebServiceParameterDefinition[] paramA = repA.getParameterDefinitions();
                    int repA_pCount = 0;
                    if (paramA != null) {
                        repA_pCount = paramA.length;
                    }
                    paramB = repB.getParameterDefinitions();
                    int repB_pCount = 0;
                    if (paramB != null) {
                        repB_pCount = paramB.length;
                    }
                    if (repA_pCount == 0 || repB_pCount == 0) continue;
                    for (iA = 0; iA < repA_pCount; ++iA) {
                        if (paramA[iA].getLexicalLevel() == 0) continue;
                        B = null;
                        for (int seqI = paramA[iA].getSequenceNumber(); seqI < repB_pCount; ++seqI) {
                            try {
                                B = repB.getParameterDefinition(seqI);
                                if (B != null && B.getLexicalLevel() == 0) {
                                    B = null;
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (B != null) break;
                        }
                        if (B == null) {
                            VWString theMessage2 = new VWString("vw.api.VWPartnerLinkFoundRepliesWithDifferentParametersA", "A Reply instruction in map(step) \"{0}\" has the same partnerlink and operation as a reply instruction in map(step) \"{1}\", but the parameters passed to these reply instruction are different, only the values of the parameters may differ. No Parameter was found in the second reply to match the parameter named \"{2}\" in the first reply.", repA.getStep().getMap().getName() + " ( " + repA.getStep().getName() + " )", repB.getStep().getMap().getName() + " ( " + repB.getStep().getName() + " )", paramA[iA].getName());
                            theError = new VWValidationError(7, 1, repA.getStep().getName(), VWActionType.typeToString(41), theMessage2.toString(), repA.getStep().getMap().getName(), repA.getStep().getStepId(), repA.getInstructionId());
                            validationContext.addValidationError(theError);
                            continue block10;
                        }
                        if (paramA[iA].isIdenticalExceptForValue(B)) continue;
                        VWString theMessage3 = new VWString("vw.api.VWPartnerLinkFoundRepliesWithDifferentParametersB", "A Reply instruction in map(step) \"{0}\" has the same partnerlink and operation as a reply instruction in map(step) \"{1}\" , but the parameters passed to these reply instruction have different definitions, only the values of the parameters may differ.  Parameters named {2} have compatible sequence numbers but different definitions.", repA.getStep().getMap().getName() + "( " + repA.getStep().getName() + " )", repB.getStep().getMap().getName() + "( " + repB.getStep().getName() + " )", paramA[iA].getName() + " (# " + String.valueOf(paramA[iA].getSequenceNumber()) + "), " + B.getName() + " (# " + String.valueOf(B.getSequenceNumber()) + ")");
                        theError = new VWValidationError(7, 1, repA.getStep().getName(), VWActionType.typeToString(41), theMessage3.toString(), repA.getStep().getMap().getName(), repA.getStep().getStepId(), repA.getInstructionId());
                        validationContext.addValidationError(theError);
                        continue block10;
                    }
                }
            }
        }
        if (!this.m_ReplyInstns.isEmpty()) {
            Enumeration RepCol = this.m_ReplyInstns.elements();
            while (RepCol.hasMoreElements()) {
                boolean found = false;
                VWReplyInstruction repA = (VWReplyInstruction)RepCol.nextElement();
                VWReceiveInstruction recI = null;
                if (!this.m_ReceiveInstns.isEmpty()) {
                    for (int i = 0; i < this.m_ReceiveInstns.size(); ++i) {
                        recI = (VWReceiveInstruction)this.m_ReceiveInstns.elementAt(i);
                        if (recI == null || recI.getOperationName() == null || repA.getOperationName() == null || !repA.getOperationName().equals(recI.getOperationName())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                VWString theMessage4 = new VWString("vw.api.VWPartnerLinkFoundRepliesWithDifferentParametersA", "A Reply instruction in map(step) \"{0}\" uses partnerlink \"{1}\" and operation \"{2}\", but no receive instruction in this workflow defines that operation.", repA.getStep().getMap().getName() + "( " + repA.getStep().getName() + " )", this.m_Name, repA.getOperationName());
                VWValidationError theError3 = new VWValidationError(7, 1, repA.getStep().getName(), VWActionType.typeToString(41), theMessage4.toString(), repA.getStep().getMap().getName(), repA.getStep().getStepId(), repA.getInstructionId());
                validationContext.addValidationError(theError3);
            }
        }
        if (!this.m_ReceiveInstns.isEmpty()) {
            outer = this.m_ReceiveInstns.elements();
            while (outer.hasMoreElements()) {
                VWReceiveInstruction recA = (VWReceiveInstruction)outer.nextElement();
                inner = this.m_ReceiveInstns.elements();
                block16: while (inner.hasMoreElements()) {
                    VWReceiveInstruction recB = (VWReceiveInstruction)inner.nextElement();
                    if (recA == recB || recA.getOperationName() == null || recA.getOperationName().length() <= 0 || recB.getOperationName() == null || recB.getOperationName().length() <= 0 || !recA.getOperationName().equals(recB.getOperationName())) continue;
                    VWWebServiceParameterDefinition[] paramA = recA.getParameterDefinitions();
                    int recA_pCount = 0;
                    if (paramA != null) {
                        recA_pCount = paramA.length;
                    }
                    paramB = recB.getParameterDefinitions();
                    int recB_pCount = 0;
                    if (paramB != null) {
                        recB_pCount = paramB.length;
                    }
                    for (iA = 0; iA < recA_pCount; ++iA) {
                        if (paramA[iA].getLexicalLevel() == 0) continue;
                        B = null;
                        for (int seqI = paramA[iA].getSequenceNumber(); seqI < recB_pCount; ++seqI) {
                            try {
                                B = recB.getParameterDefinition(seqI);
                                if (B != null && B.getLexicalLevel() == 0) {
                                    B = null;
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (B != null) break;
                        }
                        if (B == null) {
                            VWString theMessage5 = new VWString("vw.api.VWPartnerLinkFoundReceivesWithDifferentParametersA", "A Receive instruction in map(step) \"{0}\" has the same partnerlink and operation as a receive instruction in map(step) \"{1}\", but the parameters passed to these receive instruction are different, only the values of the parameters may differ. No Parameter was found in the second receive to match the parameter named \"{2}\" in the first receive.", recA.getStep().getMap().getName() + " ( " + recA.getStep().getName() + " )", recB.getStep().getMap().getName() + " ( " + recB.getStep().getName() + " )", paramA[iA].getName());
                            theError = new VWValidationError(7, 1, recA.getStep().getName(), VWActionType.typeToString(40), theMessage5.toString(), recA.getStep().getMap().getName(), recA.getStep().getStepId(), recA.getInstructionId());
                            validationContext.addValidationError(theError);
                            continue block16;
                        }
                        if (paramA[iA].isIdenticalExceptForValue(B)) continue;
                        VWString theMessage6 = new VWString("vw.api.VWPartnerLinkFoundReceiveWithDifferentParametersB", "A Receive instruction in map(step) \"{0}\" has the same partnerlink and operation as a receive instruction in map(step) \"{1}\" , but the parameters passed to these receive instruction have different definitions, only the values of the parameters may differ.  Parameters named {2} have compatible sequence numbers but different definitions.", recA.getStep().getMap().getName() + "( " + recA.getStep().getName() + " )", recB.getStep().getMap().getName() + "( " + recB.getStep().getName() + " )", paramA[iA].getName() + " (# " + String.valueOf(paramA[iA].getSequenceNumber()) + "), " + B.getName() + " (# " + String.valueOf(B.getSequenceNumber()) + ")");
                        theError = new VWValidationError(7, 1, recA.getStep().getName(), VWActionType.typeToString(40), theMessage6.toString(), recA.getStep().getMap().getName(), recA.getStep().getStepId(), recA.getInstructionId());
                        validationContext.addValidationError(theError);
                        continue block16;
                    }
                }
            }
        }
        if (this.m_ReplyInstns != null && this.m_ReplyInstns.size() > 0) {
            Vector<String> opV = new Vector<String>();
            for (int i = 0; i < this.m_ReplyInstns.size(); ++i) {
                String nextOpName = ((VWReplyInstruction)this.m_ReplyInstns.elementAt(i)).getOperationName();
                if (nextOpName == null || nextOpName.length() <= 0) continue;
                boolean alreadyInList = false;
                for (int j = 0; j < opV.size(); ++j) {
                    String nextInList = (String)opV.elementAt(j);
                    if (nextInList == null || nextInList.length() <= 0 || !nextInList.equals(nextOpName)) continue;
                    alreadyInList = true;
                    break;
                }
                if (alreadyInList) continue;
                opV.add(nextOpName);
            }
            for (int k = 0; k < opV.size(); ++k) {
                String opName = (String)opV.elementAt(k);
                boolean foundNonFaultReply = false;
                for (int l = 0; l < this.m_ReplyInstns.size(); ++l) {
                    String nextOpInReply = ((VWReplyInstruction)this.m_ReplyInstns.elementAt(l)).getOperationName();
                    if (nextOpInReply == null || nextOpInReply.length() <= 0 || !nextOpInReply.equals(opName) || ((VWReplyInstruction)this.m_ReplyInstns.elementAt(l)).getFaultName() != null) continue;
                    foundNonFaultReply = true;
                    break;
                }
                if (foundNonFaultReply) continue;
                VWString theMessage7 = new VWString("vw.api.VWPartnerLinkFoundNoNonFaultReplyForOperation", "The workflow contains at least one reply instruction for operation {0} on partner link {1}, but the workflow does not contain any non-fault replies for that operation.  If there are any replies for an operation in the workflow, at least one of those replies must be a non-fault reply.", opName, this.m_Name);
                VWValidationError theError4 = new VWValidationError(10, 1, this.m_Name, this.m_PartnerPortType, theMessage7.toString(), null);
                validationContext.addValidationError(theError4);
            }
        }
        VWSession theSession = validationContext.getVWSession();
        if (this.m_PartnerPortType != null && (this.m_PartnerEndPoint != null || this.m_WSDLRef != null) && theSession != null) {
            WSDefinition wsdef = null;
            try {
                WSWSDLRefs wsdlContents = new WSWSDLRefs(this.m_PartnerEndPoint, this.m_WSDLRef);
                wsdef = WSDefinition.getWSDefinition(theSession, wsdlContents.toString());
                if (wsdef != null && !wsdef.hasRuntimeSupport(this.m_PartnerPortType)) {
                    VWString theMessage8 = new VWString("vw.api.VWPartnerLinkDesignTimeWSDL", "The WSDL associated with the Partner Link''s partner port type is a design-time WSDL, it must be a runtime WSDL");
                    VWValidationError theError5 = new VWValidationError(10, 1, this.m_Name, this.m_PartnerPortType, theMessage8.toString(), null);
                    validationContext.addValidationError(theError5);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                VWString theMessage9 = new VWString("vw.api.VWPartnerLinkExceptionValidatingDesignTimeWSDL", "Exception happened while retrieving the web service definition during Partner Link validation.");
                VWValidationError theError6 = new VWValidationError(10, 1, this.m_Name, this.m_PartnerPortType, theMessage9.toString() + " [ " + e.getLocalizedMessage() + " ] ", null);
                validationContext.addValidationError(theError6);
            }
            finally {
                if (wsdef != null) {
                    wsdef.releaseReferences();
                    wsdef = null;
                }
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t<partnerLink");
        theBuffer.append("\n" + ATTRIB_INDENT + "name=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\"");
        if (this.m_MyPortType != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "myPortType=\"" + VWXMLHandler.toXMLString(this.m_MyPortType) + "\"");
        }
        if (this.m_MyRole != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "myRole=\"" + VWXMLHandler.toXMLString(this.m_MyRole) + "\"");
        }
        if (this.m_PartnerEndPoint != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "partnerEndPoint=\"" + VWXMLHandler.toXMLString(this.m_PartnerEndPoint) + "\"");
        }
        if (this.m_PartnerPortType != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "partnerPortType=\"" + VWXMLHandler.toXMLString(this.m_PartnerPortType) + "\"");
        }
        if (this.m_PartnerRole != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "partnerRole=\"" + VWXMLHandler.toXMLString(this.m_PartnerRole) + "\"");
        }
        if (this.m_PartnerLinkRef != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "partnerLinkRef=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkRef) + "\"");
        }
        if (this.m_WSDLRef != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "partnerWSDLRef=\"" + VWXMLHandler.toXMLString(this.m_WSDLRef) + "\"");
        }
        theBuffer.append("/>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        String[] partnerLinkTypeInfo = this.getPartnerLinkTypeInfo();
        if (partnerLinkTypeInfo != null) {
            theBuffer.append(indentA + "<PartnerLink name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\" Id=\"" + VWXMLHandler.toXMLString(this.getName()) + "\" fn:PartnerLinkRef=\"" + VWXMLHandler.toXMLString(this.getPartnerLinkRef()) + "\" PartnerLinkTypeId=\"" + partnerLinkTypeInfo[0] + "\">\n");
            if (partnerLinkTypeInfo[1] != null) {
                theBuffer.append(indentB + "<MyRole RoleName=\"" + VWXMLHandler.toXMLString(this.getMyRole()) + "\"/>\n");
            }
            if (this.getPartnerEndPoint() != null) {
                theBuffer.append(indentB + "<PartnerRole ");
                if (this.getPartnerRole() != null) {
                    theBuffer.append("RoleName=\"" + VWXMLHandler.toXMLString(this.getPartnerRole()) + "\"");
                } else {
                    theBuffer.append("RoleName=\"\"");
                }
                theBuffer.append(">\n");
                theBuffer.append(indentC + "<EndPoint");
                if (this.getWSDLRef() != null) {
                    theBuffer.append(" fn:WSDLRef=\"").append(VWXMLHandler.toXMLString(this.m_WSDLRef)).append("\"");
                }
                theBuffer.append(">\n");
                theBuffer.append(indentD + "<ExternalReference location=\"" + VWXMLHandler.toXMLString(this.getPartnerEndPoint()) + "\"/>\n");
                theBuffer.append(indentC + "</EndPoint>\n");
                theBuffer.append(indentB + "</PartnerRole>\n");
            }
            theBuffer.append(indentA + "</PartnerLink>\n");
        }
    }

    protected String[] getPartnerLinkTypeInfo() {
        String[] partnerLinkTypeInfo = new String[3];
        partnerLinkTypeInfo[0] = this.getName();
        if (this.getMyPortType() != null) {
            partnerLinkTypeInfo[0] = partnerLinkTypeInfo[0] + ".";
            String myRole = this.getMyRole();
            if (myRole != null) {
                partnerLinkTypeInfo[0] = partnerLinkTypeInfo[0] + this.getMyPortType() + "-" + myRole;
                partnerLinkTypeInfo[1] = "MyRole";
            } else {
                partnerLinkTypeInfo[0] = partnerLinkTypeInfo[0] + this.getMyPortType();
            }
        }
        if (this.getPartnerPortType() != null) {
            partnerLinkTypeInfo[0] = partnerLinkTypeInfo[0] + ".";
            String partnerRole = this.getPartnerRole();
            if (partnerRole != null) {
                partnerLinkTypeInfo[0] = partnerLinkTypeInfo[0] + this.getPartnerPortType() + "-" + partnerRole;
                partnerLinkTypeInfo[2] = "PartnerRole";
            } else {
                partnerLinkTypeInfo[0] = partnerLinkTypeInfo[0] + this.getPartnerPortType();
            }
        }
        if (partnerLinkTypeInfo[0].length() > 0) {
            partnerLinkTypeInfo[0] = VWXMLHandler.toXMLString(partnerLinkTypeInfo[0]);
        }
        return partnerLinkTypeInfo;
    }

    protected void addReceiveStepRef(VWReceiveInstruction theInst) throws VWException {
        if (!this.m_ReceiveInstns.contains(theInst)) {
            this.m_ReceiveInstns.add(theInst);
        }
    }

    protected void removeReceiveStepRef(VWReceiveInstruction theInst) throws VWException {
        this.m_ReceiveInstns.remove(theInst);
    }

    public Vector getReceiveInstructionRefs() throws VWException {
        return (Vector)this.m_ReceiveInstns.clone();
    }

    protected void addReplyStepRef(VWReplyInstruction theInst) throws VWException {
        if (!this.m_ReplyInstns.contains(theInst)) {
            this.m_ReplyInstns.add(theInst);
        }
    }

    protected void removeReplyStepRef(VWReplyInstruction theInst) throws VWException {
        this.m_ReplyInstns.remove(theInst);
    }

    protected Vector getReplyInstructionRefs() throws VWException {
        return (Vector)this.m_ReplyInstns.clone();
    }

    protected Object clone() {
        try {
            VWPartnerLinkDefinition clonedPL = (VWPartnerLinkDefinition)super.clone();
            clonedPL.m_ReceiveInstns = (Vector)this.m_ReceiveInstns.clone();
            clonedPL.m_ReplyInstns = (Vector)this.m_ReplyInstns.clone();
            return clonedPL;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void clearInstnRefs() {
        this.m_ReplyInstns = new Vector();
        this.m_ReceiveInstns = new Vector();
    }

    protected VWSession getSession() throws VWException {
        if (this.myWorkflow != null) {
            return this.myWorkflow.getSession();
        }
        return null;
    }
}

